import {
  getSpadeDataWithTimeAndLocation,
  SpadeDataWithTimeAndLocation,
} from 'mweb/common/selectors/tracking/base';
import {
  getCurrentEventForEventDetails,
  RootState,
} from 'mweb/common/reducers/root';
import { getChannelDetails } from 'mweb/common/selectors/data/channels';
import {
  EventInteractionLocation,
  EventSharedMedium,
  EventSharedPayload,
  NotificationRequest,
  NotificationRequestedPayload,
} from 'mweb/common/actions/pages/eventDetails';

interface BaseEventSpadeData extends SpadeDataWithTimeAndLocation {
  event_id: string;
  channel: string;
  channel_id: number;
  is_logged_in: boolean;
}

export interface EventShareSpadeData extends BaseEventSpadeData {
  share_medium: EventSharedMedium;
  location: EventInteractionLocation;
  is_logged_in: boolean;
}

export interface EventNotificationRequestSpadeData extends BaseEventSpadeData {
  action: NotificationRequest;
}

export function getEventSharedSpadeData(
  state: RootState,
  payload: EventSharedPayload,
): EventShareSpadeData {
  const event = getCurrentEventForEventDetails(state);
  const channel = event && getChannelDetails(state, event.channel);
  return {
    ...getSpadeDataWithTimeAndLocation(state),
    share_medium: payload.medium,
    event_id: event ? event.id : '',
    location: payload.location,
    channel: channel ? channel.name : '',
    channel_id: channel ? parseInt(channel.id) : 0,
    is_logged_in: false,
  };
}

export function getEventNotificationRequestedSpadeData(
  state: RootState,
  payload: NotificationRequestedPayload,
): EventNotificationRequestSpadeData {
  const event = getCurrentEventForEventDetails(state);
  const channel = event && getChannelDetails(state, event.channel);
  return {
    ...getSpadeDataWithTimeAndLocation(state),
    action: payload.request,
    event_id: event ? event.id : '',
    location: payload.location,
    channel: channel ? channel.name : '',
    channel_id: channel ? parseInt(channel.id) : 0,
    is_logged_in: false,
  };
}
