import {
  getSpadeDataWithTimeAndLocation,
  SpadeDataWithTimeAndLocation,
} from 'mweb/common/selectors/tracking/base';
import { RootState } from 'mweb/common/reducers/root';
import {
  ExperimentUUIDs,
  ExperimentNames,
  ExperimentGroups,
  ExperimentData,
} from 'mweb/common/actions/experiments';

export interface ExperimentBranchSpadeData
  extends SpadeDataWithTimeAndLocation {
  experiment_id: ExperimentUUIDs | undefined;
  experiment_name: ExperimentNames;
  experiment_group: ExperimentGroups;
}

export function getExperimentBranchSpadeData(
  state: RootState,
  experimentData: ExperimentData,
): ExperimentBranchSpadeData {
  return {
    ...getSpadeDataWithTimeAndLocation(state),
    experiment_id: experimentData.uuid,
    experiment_name: experimentData.name,
    experiment_group: experimentData.group,
  };
}
