import {
  getSpadeDataWithTimeAndLocation,
  SpadeDataWithTimeAndLocation,
} from 'mweb/common/selectors/tracking/base';
import { RootState } from 'mweb/common/reducers/root';
import { UITrackingPayload } from 'mweb/common/actions/tracking';

enum UIInteractionType {
  Click = 'click',
}

interface UIInteractionSpadeData extends SpadeDataWithTimeAndLocation {
  interaction_medium: string;
  interaction_content: string;
  interaction_target_path: string | undefined;
  interaction: UIInteractionType;
}

export interface ClickTrackedSpadeData extends UIInteractionSpadeData {}

export function getClickTrackedSpadeData(
  state: RootState,
  payload: UITrackingPayload,
): ClickTrackedSpadeData {
  return {
    ...getSpadeDataWithTimeAndLocation(state),
    interaction_medium: payload.interactionMedium,
    interaction_content: payload.interactionContent,
    interaction_target_path: payload.interactionTargetPath,
    interaction: UIInteractionType.Click,
    location: state.app.location,
  };
}
