const TOP_NAV_HEIGHT = 50;

export enum ImageType {
  BoxArt,
  Channel,
}

export function estimateImageCountForViewport(
  aspectRatio: number,
  heightFudge: number, // extra "height" added to image to account for decorations above or below
  imageType: ImageType,
  viewportWidth: number = window.document.documentElement.clientWidth,
  viewportHeight: number = window.document.documentElement.clientHeight,
): number {
  const usableViewportHeight = viewportHeight - TOP_NAV_HEIGHT;

  let columnCount;
  switch (imageType) {
    case ImageType.BoxArt:
      if (viewportWidth < viewportHeight && viewportWidth <= 540) {
        columnCount = 2;
      } else {
        columnCount = 4;
      }
      break;
    case ImageType.Channel:
      if (viewportWidth < viewportHeight && viewportWidth <= 540) {
        columnCount = 1;
      } else if (viewportWidth > viewportHeight && viewportWidth >= 768) {
        columnCount = 3;
      } else {
        columnCount = 2;
      }
      break;
    default:
      columnCount = 1;
      break;
  }

  const itemWidth = viewportWidth / columnCount;
  const itemHeight = itemWidth * aspectRatio + heightFudge;
  const rowCount = Math.ceil(usableViewportHeight / itemHeight);
  return columnCount * rowCount;
}
