const MINUTE = 60;
const HOUR = 60 * MINUTE;
const DAY = 24 * HOUR;

export function formatVideoLength(length: number): string {
  let remainingTime = length;
  const days = Math.floor(remainingTime / DAY);
  remainingTime -= days * DAY;
  const hours = Math.floor(remainingTime / HOUR);
  remainingTime -= hours * HOUR;
  const minutes = Math.floor(remainingTime / MINUTE);

  const timePieces = [days, hours, minutes, remainingTime - minutes * MINUTE];

  while (timePieces[0] === 0 && timePieces.length > 2) {
    timePieces.shift();
  }

  return timePieces
    .map((val, idx) => (idx === 0 || val > 9 ? val : `0${val}`))
    .join(':');
}
