import { Location } from 'history';

interface ParamsMap extends Record<string, string> {}

export default function getQueryParamsFromHistoryLocation(
  location: Location,
): ParamsMap {
  let paramsMap: ParamsMap = {};
  const pieces = location.search.slice(1).split(/[&=]/g);
  for (let i = 0; i < pieces.length; i += 2) {
    paramsMap[pieces[i]] = pieces[i + 1];
  }
  return paramsMap;
}
