import { ALL_CHANNELS } from 'mweb/common/reducers/data/channels';
import {
  VideoType,
  BaseVideoDetails,
} from 'mweb/common/reducers/data/baseVideoDetails';
import { ClipDetails } from 'mweb/common/reducers/data/clips';

export type AppPath = string;

export function buildLandingPagePath(): AppPath {
  return '/';
}

export function buildGameDirectoryPath(): AppPath {
  return '/directory';
}

export function buildChannelDirectoryPathFromEncodedGame(
  game: string,
): AppPath {
  return game === ALL_CHANNELS ? '/directory/all' : `/directory/game/${game}`;
}

export function twitchEncodeURIComponent(component: string): string {
  return encodeURIComponent(component).replace('%3A', ':');
}

export function buildChannelDirectoryPathFromDecodedGame(
  game: string,
): AppPath {
  return buildChannelDirectoryPathFromEncodedGame(
    twitchEncodeURIComponent(game),
  );
}

export function buildChannelPath(channel: string): AppPath {
  return `/${channel}`;
}

export function buildChannelProfilePath(channel: string): AppPath {
  return `/${channel}/profile`;
}

export function buildEventPath(eventID: string): AppPath {
  return `/events/${eventID}`;
}

export function buildVODPath(vodID: string): AppPath {
  return `/videos/${vodID.charAt(0) === 'v' ? vodID.slice(1) : vodID}`;
}

export function buildLegacyVODPath(channel: string, vodID: string): AppPath {
  return buildVODPath(vodID).replace('videos', `${channel}/v`);
}

export function buildPathForBaseVideo(video: BaseVideoDetails): AppPath {
  switch (video.videoType) {
    case VideoType.Clip:
      return (video as ClipDetails).url;
    case VideoType.Archive:
    case VideoType.Highlight:
    default:
      return buildVODPath(video.id);
  }
}
