import {
  EventModel,
  PremiereEventModel,
  EventType,
  PremiereStatus,
} from 'mweb/common/reducers/data/events';

export function isPremiereEvent(
  event: EventModel,
): event is PremiereEventModel {
  return event.type === EventType.PremiereEvent;
}

export const supportedPremiereEvents = [
  PremiereStatus.Scheduled,
  PremiereStatus.Cancelled,
  PremiereStatus.Started,
  PremiereStatus.Success,
  PremiereStatus.Failed,
];

export function isUnsupportedPremiereEvent(event: EventModel): Boolean {
  if (isPremiereEvent(event)) {
    return !supportedPremiereEvents.includes(event.premiere.status);
  }
  return false;
}
