import { RootState } from 'mweb/common/reducers/root';
import { logger } from 'tachyon-logger';

/**
 * Decorates the callback with a function that will log the status of the
 * response for pager alerts.
 *
 * @param callback
 * @param state
 */
export function getLoggingCallback<T>(
  callback: AWS.Lambda.Callback<T>,
  state?: RootState,
): AWS.Lambda.Callback<T> {
  return (error: T, result: T): void => {
    const location = state && state.app.location;
    const errorCondition = state && state.app.errorCondition;
    const isError = !!errorCondition;
    if (isError) {
      logger.error({
        location,
        isError,
        errorCondition,
      });
    } else {
      logger.info({ location, isError });
    }
    return callback(error, result);
  };
}
