import expect from 'expect';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';

import { LatencyTrackedImage } from 'mweb/common/latency/latencyTrackedImage';

describe('LatencyTrackedImage', () => {
  const subject = partialPropShallowWrapper(LatencyTrackedImage, {});

  it('renders an img element and does not set latencyName when given no alt', () => {
    const lti = subject();
    expect(lti.find('img').length).toEqual(1);
    expect((lti.instance() as LatencyTrackedImage).latencyName).toEqual(
      undefined,
    );
  });

  it('generates a custom latencyName without word characters when given an alt value', () => {
    expect(
      (subject({
        alt: 'Twitch: The Greatest',
      }).instance() as LatencyTrackedImage).latencyName,
    ).toEqual('TwitchTheGreatest_Image');
  });
});
