import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import expectToReturnType from 'mtest/helpers/expectToReturnType';
import {
  VOD,
  NOT_VOD,
  mockVOD,
  mockVODNotFound,
  VOD_DATA_PAYLOAD,
} from 'mtest/fetchMocks/vods';

import {
  VODS_DATA_VOD_LOADED_ACTION_TYPE,
  VODS_DATA_VOD_FAILED_ACTION_TYPE,
  vodsDataFetchVOD,
  vodsDataLoadVOD,
} from 'mweb/common/actions/data/vods';

describe('vodsData actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('vodsDataFetchVOD', () => {
    it('resolves both vod details on success', () => {
      const store = createTestStore();
      mockVOD();

      return store.dispatch(vodsDataFetchVOD(VOD)).then(() => {
        const actions = store.getActions();
        expect(actions.shift()).toEqual(vodsDataLoadVOD(VOD_DATA_PAYLOAD));
      });
    });

    it('rejects a not found vod', () => {
      const store = createTestStore();
      mockVODNotFound();

      return store.dispatch(vodsDataFetchVOD(NOT_VOD)).then(() => {
        const actions = store.getActions();
        expect(actions.shift().type).toEqual(VODS_DATA_VOD_FAILED_ACTION_TYPE);
      });
    });
  });

  describe('vodsDataLoadVOD', () => {
    expectToReturnType(vodsDataLoadVOD, VODS_DATA_VOD_LOADED_ACTION_TYPE);
  });
});
