import expect from 'expect';
import difference from 'lodash-es/difference';

import createTestStore from '../helpers/createTestStore';

import {
  ExperimentUUIDs,
  ExperimentNames,
  ExperimentGroups,
  experimentsRecordDecision,
  experimentsDecisionRecordedActionBuilder,
} from 'mweb/common/actions/experiments';
import { Enum } from 'mweb/common/utils/enum';

describe('Experiment UUIDS and Names', () => {
  it('have matching keys', () => {
    const uuidKeys = Enum.keys(ExperimentUUIDs);
    const nameKeys = Enum.keys(ExperimentNames);

    expect(difference(uuidKeys, nameKeys)).toEqual([]);
    expect(difference(nameKeys, uuidKeys)).toEqual([]);
  });
});

describe('experimentsRecordDecision', () => {
  const data = {
    uuid: ExperimentUUIDs.Test,
    name: ExperimentNames.Test,
    group: ExperimentGroups.Control,
  };

  it('records decision if not already recorded', () => {
    const store = createTestStore();
    store.dispatch(experimentsRecordDecision(data));
    const actions = store.getActions();
    expect(actions.shift()).toEqual(
      experimentsDecisionRecordedActionBuilder(data),
    );
  });

  it('does not records decision if already recorded', () => {
    const store = createTestStore({
      experiments: {
        recordedDecisions: {
          [ExperimentNames.Test]: ExperimentGroups.Control,
        },
      },
    });
    store.dispatch(experimentsRecordDecision(data));
    const actions = store.getActions();
    expect(actions.length).toEqual(0);
  });
});
