import expect from 'expect';

import expectToReturnType from 'mtest/helpers/expectToReturnType';
import createTestStore from 'mtest/helpers/createTestStore';

import {
  NAVIGATION_UPDATED_LOCATION_ACTION_TYPE,
  NAVIGATION_SWITCHED_TO_DESKTOP_ACTION_TYPE,
  navigationUpdateLocation,
  navigationUpdatedLocationActionBuilder,
  navigationDeclineMobileWebExperience,
  navigationDeclineUpsell,
} from 'mweb/common/actions/navigation';
import { Location } from 'mweb/common/reducers/app';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
} from 'mweb/common/actions/tracking';
import {
  MOBILE_OPT_OUT_COOKIE_NAME,
  UPSELL_OPT_OUT_COOKIE_NAME,
} from 'mweb/common/utils/cookie';

describe('navigation actions', () => {
  describe('navigationUpdateLocation', () => {
    it('dispatches the correct series of actions', () => {
      const store = createTestStore();
      store.dispatch(navigationUpdateLocation(Location.DirectoryMainGame));
      const actions = store.getActions();

      expect(actions.shift()).toEqual(
        navigationUpdatedLocationActionBuilder(Location.DirectoryMainGame),
      );
      expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
      expect(actions.shift()).toEqual(trackingClearTrackingParams());
    });
  });

  describe('navigationUpdatedLocationActionBuilder', () => {
    it(`passes proper location as payload`, () => {
      expect(navigationUpdatedLocationActionBuilder(Location.Channel)).toEqual({
        type: NAVIGATION_UPDATED_LOCATION_ACTION_TYPE,
        payload: {
          location: Location.Channel,
        },
      });
    });
  });

  describe('navigationSwitchToDesktop', () => {
    describe('navigationDeclineMobileWebExperience', () => {
      expectToReturnType(
        navigationDeclineMobileWebExperience,
        NAVIGATION_SWITCHED_TO_DESKTOP_ACTION_TYPE,
      );

      it('sets the right cookie name', () => {
        expect(
          navigationDeclineMobileWebExperience().payload.cookieName,
        ).toEqual(MOBILE_OPT_OUT_COOKIE_NAME);
      });
    });

    describe('navigationDeclineUpsell', () => {
      expectToReturnType(
        navigationDeclineUpsell,
        NAVIGATION_SWITCHED_TO_DESKTOP_ACTION_TYPE,
      );

      it('sets the right cookie name', () => {
        expect(navigationDeclineUpsell().payload.cookieName).toEqual(
          UPSELL_OPT_OUT_COOKIE_NAME,
        );
      });
    });
  });
});
