import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import {
  GAME_CHANNELS_DATA_PAYLOAD,
  ALL_GAMES_CHANNELS_DATA_PAYLOAD,
  mockChannelsForGame,
  mockChannelsAllGames,
} from 'mtest/fetchMocks/channels';
import { GAME_1 } from 'mtest/fetchMocks/games';

import {
  CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE,
  channelDirectoryPageTransition,
  channelDirectoryPageUpdateGameAlias,
} from 'mweb/common/actions/pages/channelDirectory';
import {
  channelsDataReinitializeForGame,
  channelsDataLoadPage,
} from 'mweb/common/actions/data/channels';
import { navigationUpdatedLocationActionBuilder } from 'mweb/common/actions/navigation';
import { Location } from 'mweb/common/reducers/app';
import { ALL_CHANNELS } from 'mweb/common/reducers/data/channels';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
} from 'mweb/common/actions/tracking';

describe('channelDirectory actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('channelDirectoryPageTransition', () => {
    it('updates location after loading data for a game', () => {
      const store = createTestStore();
      mockChannelsForGame();

      return store
        .dispatch(channelDirectoryPageTransition(GAME_1.name))
        .then(() => {
          const actions = store.getActions();
          expect(actions.shift()).toEqual(
            channelDirectoryPageUpdateGameAlias(GAME_1.name),
          );
          expect(actions.shift()).toEqual(
            channelsDataLoadPage(GAME_CHANNELS_DATA_PAYLOAD),
          );
          expect(actions.shift()).toEqual(
            navigationUpdatedLocationActionBuilder(Location.DirectoryGame),
          );
          expect(actions.shift()).toEqual(
            trackingPageViewTrackedActionBuilder(),
          );
          expect(actions.shift()).toEqual(trackingClearTrackingParams());
        });
    });

    it('updates location after loading data for ALL_CHANNELS', () => {
      const store = createTestStore();
      mockChannelsAllGames();

      return store
        .dispatch(channelDirectoryPageTransition(ALL_CHANNELS))
        .then(() => {
          const actions = store.getActions();
          expect(actions.shift()).toEqual(
            channelDirectoryPageUpdateGameAlias(ALL_CHANNELS),
          );
          expect(actions.shift()).toEqual(
            channelsDataReinitializeForGame(ALL_CHANNELS),
          );
          expect(actions.shift()).toEqual(
            channelsDataLoadPage(ALL_GAMES_CHANNELS_DATA_PAYLOAD),
          );
          expect(actions.shift()).toEqual(
            navigationUpdatedLocationActionBuilder(Location.DirectoryGame),
          );
          expect(actions.shift()).toEqual(
            trackingPageViewTrackedActionBuilder(),
          );
          expect(actions.shift()).toEqual(trackingClearTrackingParams());
        });
    });
  });

  describe('channelDirectoryPageUpdateGame', () => {
    it('creates the proper payload', () => {
      expect(channelDirectoryPageUpdateGameAlias(GAME_1.name)).toEqual({
        type: CHANNEL_DIRECTORY_PAGE_GAME_ALIAS_UPDATED_ACTION_TYPE,
        payload: {
          gameAlias: GAME_1.name,
        },
      });
    });
  });
});
