import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import { CHANNEL_DATA_PAYLOAD, mockChannel } from 'mtest/fetchMocks/channel';

import { channelsDataLoadChannel } from 'mweb/common/actions/data/channels';
import { Location } from 'mweb/common/reducers/app';
import { navigationUpdatedLocationActionBuilder } from 'mweb/common/actions/navigation';
import {
  CHANNEL_PROFILE_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
  channelProfilePageTransition,
  channelProfilePageUpdateChannel,
  channelProfilePageRedirectAsOffline,
  CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE,
} from 'mweb/common/actions/pages/channelProfile';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
  trackingTrackProfilePageView,
} from 'mweb/common/actions/tracking';
import { getProfileContentTargetVideoCounts } from 'mweb/common/selectors/pages/channelProfile';

const CHANNEL = 'monsterabbit';

describe('channelProfile actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('channelProfilePageUpdateChannel', () => {
    it('creates the correct action', () => {
      expect(channelProfilePageUpdateChannel(CHANNEL)).toEqual({
        type: CHANNEL_PROFILE_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
        payload: {
          channel: CHANNEL,
        },
      });
    });
  });

  describe('channelProfilePageRedirectAsOffline', () => {
    it('dispatches a redirect action and then a profile page transition', () => {
      mockChannel();

      const store = createTestStore();

      store
        .dispatch(
          channelProfilePageRedirectAsOffline(
            CHANNEL,
            getProfileContentTargetVideoCounts(),
          ),
        )
        .then(() => {
          const actions = store.getActions();

          expect(actions.shift()).toEqual({
            type: 'CHANNEL_PROFILE_PAGE_CHANNEL_UPDATED_ACTION_TYPE',
            payload: { channel: 'monsterabbit' },
          });
          expect(actions.shift()).toEqual({
            type: CHANNEL_PROFILE_PAGE_REDIRECTED_AS_OFFLINE,
            payload: {},
          });
        });
    });
  });

  describe('channelProfilePageTransition', () => {
    it('it updates channel & location', () => {
      mockChannel();

      const store = createTestStore();

      return store
        .dispatch(
          channelProfilePageTransition(
            CHANNEL,
            getProfileContentTargetVideoCounts(),
          ),
        )
        .then(() => {
          const actions = store.getActions();
          expect(actions.shift()).toEqual(
            channelProfilePageUpdateChannel(CHANNEL),
          );
          expect(actions.shift()).toEqual(
            channelsDataLoadChannel(CHANNEL_DATA_PAYLOAD),
          );
          expect(actions.shift()).toEqual(
            navigationUpdatedLocationActionBuilder(Location.ChannelProfile),
          );

          expect(actions.shift()).toEqual(
            trackingPageViewTrackedActionBuilder(),
          );
          expect(actions.shift()).toEqual(trackingTrackProfilePageView());
          expect(actions.shift()).toEqual(trackingClearTrackingParams());
        });
    });
  });
});
