import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import {
  CHANNEL,
  CHANNEL_DATA_PAYLOAD,
  mockChannel,
} from 'mtest/fetchMocks/channel';

import {
  CHAT_EMBED_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
  chatEmbedPageTransition,
  chatEmbedPageTransitionClient,
  chatEmbedPageUpdateChannel,
} from 'mweb/common/actions/pages/chatEmbed';
import { channelsDataLoadChannel } from 'mweb/common/actions/data/channels';
import { navigationUpdatedLocationActionBuilder } from 'mweb/common/actions/navigation';
import { Location } from 'mweb/common/reducers/app';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
} from 'mweb/common/actions/tracking';

describe('chatEmbed actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('chatEmbedPageTransition', () => {
    it('updates location after loading data', () => {
      const store = createTestStore();
      mockChannel();

      return store.dispatch(chatEmbedPageTransition(CHANNEL)).then(() => {
        const actions = store.getActions();
        expect(actions.shift()).toEqual(chatEmbedPageUpdateChannel(CHANNEL));
        expect(actions.shift()).toEqual(
          channelsDataLoadChannel(CHANNEL_DATA_PAYLOAD),
        );
        expect(actions.shift()).toEqual(
          navigationUpdatedLocationActionBuilder(Location.ChatEmbed),
        );
        expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
        expect(actions.shift()).toEqual(trackingClearTrackingParams());
      });
    });
  });

  describe('chatEmbedPageTransitionClient', () => {
    it('dispatches page view', () => {
      const store = createTestStore();
      store.dispatch(chatEmbedPageTransitionClient());

      const actions = store.getActions();
      expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
      expect(actions.shift()).toEqual(trackingClearTrackingParams());
    });
  });

  describe('chatEmbedPageUpdateChannel', () => {
    it('creates the proper payload', () => {
      expect(chatEmbedPageUpdateChannel(CHANNEL)).toEqual({
        type: CHAT_EMBED_PAGE_CHANNEL_UPDATED_ACTION_TYPE,
        payload: {
          channel: CHANNEL,
        },
      });
    });
  });
});
