import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import { EVENT_ID, EVENT_PAYLOAD, mockEvent } from 'mtest/fetchMocks/event';

import {
  EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE,
  EVENT_DETAILS_PAGE_EVENT_SHARED_ACTION_TYPE,
  EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_ACTION_TYPE,
  eventDetailsPageTransition,
  eventDetailsPageUpdateEvent,
  eventDetailsPageShareEvent,
  eventDetailsPageRequestNotification,
} from 'mweb/common/actions/pages/eventDetails';
import { eventsDataLoadEvent } from 'mweb/common/actions/data/events';
import { navigationUpdatedLocationActionBuilder } from 'mweb/common/actions/navigation';
import { Location } from 'mweb/common/reducers/app';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
} from 'mweb/common/actions/tracking';

describe('eventDetails actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('eventDetailsPageTransition', () => {
    it('updates location after loading data', () => {
      const store = createTestStore();
      mockEvent();

      return store.dispatch(eventDetailsPageTransition(EVENT_ID)).then(() => {
        const actions = store.getActions();
        expect(actions.shift()).toEqual(eventDetailsPageUpdateEvent(EVENT_ID));
        expect(actions.shift()).toEqual(eventsDataLoadEvent(EVENT_PAYLOAD));
        expect(actions.shift()).toEqual(
          navigationUpdatedLocationActionBuilder(Location.EventDetails),
        );
        expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
        expect(actions.shift()).toEqual(trackingClearTrackingParams());
      });
    });
  });

  describe('eventDetailsPageUpdateEvent', () => {
    it('creates the proper payload', () => {
      expect(eventDetailsPageUpdateEvent(EVENT_ID)).toEqual({
        type: EVENT_DETAILS_PAGE_EVENT_UPDATED_ACTION_TYPE,
        payload: {
          eventID: EVENT_ID,
        },
      });
    });
  });

  describe('eventDetailsPageShareEvent', () => {
    it('creates the proper payload', () => {
      expect(
        eventDetailsPageShareEvent('twitter', Location.EventDetails),
      ).toEqual({
        type: EVENT_DETAILS_PAGE_EVENT_SHARED_ACTION_TYPE,
        payload: {
          medium: 'twitter',
          location: 'event_details',
        },
      });
    });
  });

  describe('eventDetailsPageRequestNotification', () => {
    it('creates the proper payload', () => {
      expect(
        eventDetailsPageRequestNotification(
          'google_calendar',
          Location.EventDetails,
        ),
      ).toEqual({
        type: EVENT_DETAILS_PAGE_NOTIFICATION_REQUESTED_ACTION_TYPE,
        payload: {
          request: 'google_calendar',
          location: 'event_details',
        },
      });
    });
  });
});
