import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import { PARSED_GAMES_PAYLOAD, mockGames } from 'mtest/fetchMocks/games';

import { gameDirectoryPageTransition } from 'mweb/common/actions/pages/gameDirectory';
import {
  gamesDataReinitialize,
  gamesDataLoadPage,
} from 'mweb/common/actions/data/games';
import { navigationUpdatedLocationActionBuilder } from 'mweb/common/actions/navigation';
import { Location } from 'mweb/common/reducers/app';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
} from 'mweb/common/actions/tracking';

describe('gameDirectory actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('gameDirectoryPageTransition', () => {
    it('updates location after loading data', () => {
      const store = createTestStore();
      mockGames();

      return store.dispatch(gameDirectoryPageTransition()).then(() => {
        const actions = store.getActions();
        expect(actions.shift()).toEqual(gamesDataReinitialize());
        expect(actions.shift()).toEqual(
          gamesDataLoadPage(PARSED_GAMES_PAYLOAD),
        );
        expect(actions.shift()).toEqual(
          navigationUpdatedLocationActionBuilder(Location.DirectoryMainGame),
        );
        expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
        expect(actions.shift()).toEqual(trackingClearTrackingParams());
      });
    });
  });
});
