import expect from 'expect';
import fetchMock from 'fetch-mock';

import createTestStore from 'mtest/helpers/createTestStore';
import { VOD, VOD_DATA_PAYLOAD, mockVOD } from 'mtest/fetchMocks/vods';

import {
  VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE,
  vodViewerPageTransition,
  vodViewerPageUpdateVOD,
} from 'mweb/common/actions/pages/vodViewer';
import { vodsDataLoadVOD } from 'mweb/common/actions/data/vods';
import { navigationUpdatedLocationActionBuilder } from 'mweb/common/actions/navigation';
import { Location } from 'mweb/common/reducers/app';
import {
  trackingPageViewTrackedActionBuilder,
  trackingClearTrackingParams,
} from 'mweb/common/actions/tracking';

describe('vodViewer actions', () => {
  afterEach(() => {
    expect(fetchMock.done()).toEqual(true);
    fetchMock.restore();
  });

  describe('vodViewerPageTransition', () => {
    it('updates location after loading data', () => {
      const store = createTestStore();
      mockVOD();

      return store.dispatch(vodViewerPageTransition(VOD)).then(() => {
        const actions = store.getActions();
        expect(actions.shift()).toEqual(vodViewerPageUpdateVOD(VOD));
        expect(actions.shift()).toEqual(vodsDataLoadVOD(VOD_DATA_PAYLOAD));
        expect(actions.shift()).toEqual(
          navigationUpdatedLocationActionBuilder(Location.VOD),
        );
        expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
        expect(actions.shift()).toEqual(trackingClearTrackingParams());
      });
    });
  });

  describe('vodViewerPageUpdateVOD', () => {
    it('creates the proper payload', () => {
      expect(vodViewerPageUpdateVOD(VOD)).toEqual({
        type: VOD_VIEWER_PAGE_VOD_UPDATED_ACTION_TYPE,
        payload: {
          vodID: VOD,
        },
      });
    });
  });
});
