import expect from 'expect';

import expectToReturnType from 'mtest/helpers/expectToReturnType';
import createTestStore from 'mtest/helpers/createTestStore';

import {
  TRACKING_PAGE_VIEW_TRACKED_ACTION_TYPE,
  TRACKING_PARAMS_CAPTURED_ACTION_TYPE,
  TRACKING_CLICK_TRACKED_ACTION_TYPE,
  TRACKING_SUBSCRIBE_TRACKED_ACTION_TYPE,
  TRACKING_PARAMS_CLEARED_ACTION_TYPE,
  TRACKING_PROFILE_PAGE_VIEW_TRACKED_ACTION_TYPE,
  trackingClearTrackingParams,
  trackingCaptureTrackingParams,
  trackingTrackPageView,
  trackingPageViewTrackedActionBuilder,
  trackingTrackClick,
  trackingTrackProfilePageView,
  UITrackingPayload,
} from 'mweb/common/actions/tracking';
import { Location } from 'mweb/common/reducers/app';

describe('tracking actions', () => {
  describe('trackingTrackPageView', () => {
    it('works for profile pages', () => {
      const store = createTestStore();
      store.dispatch(trackingTrackPageView(Location.ChannelProfile));

      const actions = store.getActions();
      expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
      expect(actions.shift()).toEqual(trackingTrackProfilePageView());
      expect(actions.shift()).toEqual(trackingClearTrackingParams());
    });

    it('works for non-profile pages', () => {
      const store = createTestStore();
      store.dispatch(trackingTrackPageView(Location.Channel));

      const actions = store.getActions();
      expect(actions.shift()).toEqual(trackingPageViewTrackedActionBuilder());
      expect(actions.shift()).toEqual(trackingClearTrackingParams());
    });
  });

  describe('trackingPageViewTrackedActionBuilder', () => {
    expectToReturnType(
      trackingPageViewTrackedActionBuilder,
      TRACKING_PAGE_VIEW_TRACKED_ACTION_TYPE,
    );
  });

  describe('trackingPageViewTrackedActionBuilder', () => {
    expectToReturnType(
      trackingTrackProfilePageView,
      TRACKING_PROFILE_PAGE_VIEW_TRACKED_ACTION_TYPE,
    );
  });

  describe('trackingClearTrackingParams', () => {
    expectToReturnType(
      trackingClearTrackingParams,
      TRACKING_PARAMS_CLEARED_ACTION_TYPE,
    );
  });

  describe('trackingCaptureTrackingParams', () => {
    expectToReturnType(
      trackingCaptureTrackingParams,
      TRACKING_PARAMS_CAPTURED_ACTION_TYPE,
      { content: undefined, medium: undefined },
    );

    it('assigns just the medium', () => {
      expect(
        trackingCaptureTrackingParams({
          tt_medium: 'foo',
          tt_content: undefined,
        }).payload,
      ).toEqual({
        tt_medium: 'foo',
        tt_content: undefined,
      });
    });

    it('assigns just the content', () => {
      expect(
        trackingCaptureTrackingParams({
          tt_content: 'foo',
          tt_medium: undefined,
        }).payload,
      ).toEqual({
        tt_content: 'foo',
        tt_medium: undefined,
      });
    });

    it('assigns both the content and medium', () => {
      expect(
        trackingCaptureTrackingParams({ tt_content: 'foo', tt_medium: 'bar' })
          .payload,
      ).toEqual({
        tt_content: 'foo',
        tt_medium: 'bar',
      });
    });
  });

  describe('trackingTrackClick', () => {
    it('returns the right payload for normal clicks', () => {
      const store = createTestStore();
      const payload: UITrackingPayload = {
        interactionMedium: 'medium',
        interactionContent: 'content',
        interactionTargetPath: '/path',
      };

      store.dispatch(trackingTrackClick(payload));
      const actions = store.getActions();
      expect(actions.shift()).toEqual({
        type: TRACKING_CLICK_TRACKED_ACTION_TYPE,
        payload,
      });
    });

    it('returns the right payloads for subscribe clicks', () => {
      const store = createTestStore();
      const payload: UITrackingPayload = {
        interactionMedium: 'medium',
        interactionContent: 'content',
        interactionTargetPath: '/subs',
        interactionSubscribe: true,
      };

      store.dispatch(trackingTrackClick(payload));
      const actions = store.getActions();
      expect(actions.shift()).toEqual({
        type: TRACKING_SUBSCRIBE_TRACKED_ACTION_TYPE,
        payload,
      });
      expect(actions.shift()).toEqual({
        type: TRACKING_CLICK_TRACKED_ACTION_TYPE,
        payload,
      });
    });
  });
});
