import expect from 'expect';

import expectToReturnType from 'mtest/helpers/expectToReturnType';
import { buildTestMessageEvent } from 'mtest/chat/helpers/chatObjects';

import {
  chatUpdateMessages,
  chatInitializeEmbed,
  CHAT_MESSAGES_UPDATED,
  CHAT_EMBED_INITIALIZED,
} from 'mweb/chat/chatAction';

describe('chat actions', () => {
  describe('chatMessages', () => {
    expectToReturnType(chatUpdateMessages, CHAT_MESSAGES_UPDATED);

    it('passes the proper payload', () => {
      const messages = [buildTestMessageEvent()];
      expect(chatUpdateMessages(messages).payload.messages).toEqual(messages);
    });
  });

  describe('chatSetEmbed', () => {
    expectToReturnType(chatInitializeEmbed, CHAT_EMBED_INITIALIZED);

    it('passes the proper payload', () => {
      expect(chatInitializeEmbed('dark', 'large').payload).toEqual({
        theme: 'dark',
        fontSize: 'large',
      });
    });
  });
});
