import expect from 'expect';

import { buildTestMessageEvent } from 'mtest/chat/helpers/chatObjects';

import { Action } from 'mweb/common/actions/root';
import {
  CHAT_MESSAGES_UPDATED,
  CHAT_RESET,
  CHAT_EMBED_INITIALIZED,
} from 'mweb/chat/chatAction';
import { chat, ChatState } from 'mweb/chat/chatReducer';

describe('chat reducer', () => {
  it('sets reasonable defaults', () => {
    expect(chat(undefined, { type: 'NOOP' })).toEqual({
      messages: [],
      embedOptions: undefined,
    });
  });

  it('sets the message list', () => {
    const message = buildTestMessageEvent();
    const action: Action = {
      type: CHAT_MESSAGES_UPDATED,
      payload: {
        messages: [message],
      },
    };
    expect(chat(undefined, action)).toEqual({
      messages: [message],
      embedOptions: undefined,
    });
  });

  it('resets chat state', () => {
    const initialChatState: ChatState = {
      messages: [buildTestMessageEvent()],
      embedOptions: {},
    };
    expect(chat(initialChatState, { type: CHAT_RESET })).toEqual({
      messages: [],
      embedOptions: undefined,
    });
  });

  it('sets chat embed options', () => {
    const action: Action = {
      type: CHAT_EMBED_INITIALIZED,
      payload: {
        theme: 'dark',
        fontSize: 'large',
      },
    };
    const message = buildTestMessageEvent();
    const initialChatState: ChatState = {
      messages: [message],
      embedOptions: undefined,
    };
    expect(chat(initialChatState, action)).toEqual({
      messages: [message],
      embedOptions: {
        theme: 'dark',
        fontSize: 'large',
      },
    });
  });
});
