import fetchMock from 'fetch-mock';

import {
  GLOBAL_BADGES_URL,
  makeChannelBadgeURL,
  BadgesPayload,
} from 'mweb/chat/badgerService';

export const GLOBAL_SUBSCRIBER_VERSION_0_URL =
  'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/1';

export const TEST_CHANNEL_ID = '23161357';
export const TEST_CHANNEL_ID_2 = '23161358';

interface BadgesResponse {
  badge_sets: BadgesPayload;
}

const GLOBAL_BADGES_JSON: BadgesResponse = {
  badge_sets: {
    subscriber: {
      versions: {
        '0': {
          image_url_1x: GLOBAL_SUBSCRIBER_VERSION_0_URL,
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/3',
          description: 'Subscriber',
          title: 'Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
        '1': {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/3',
          description: 'Subscriber',
          title: 'Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
      },
    },
    warcraft: {
      versions: {
        alliance: {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/c4816339-bad4-4645-ae69-d1ab2076a6b0/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/c4816339-bad4-4645-ae69-d1ab2076a6b0/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/c4816339-bad4-4645-ae69-d1ab2076a6b0/3',
          description: 'For Lordaeron!',
          title: 'Alliance',
          click_action: 'visit_url',
          click_url: 'http://warcraftontwitch.tv/',
        },
        horde: {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/de8b26b6-fd28-4e6c-bc89-3d597343800d/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/de8b26b6-fd28-4e6c-bc89-3d597343800d/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/de8b26b6-fd28-4e6c-bc89-3d597343800d/3',
          description: 'For the Horde!',
          title: 'Horde',
          click_action: 'visit_url',
          click_url: 'http://warcraftontwitch.tv/',
        },
      },
    },
  },
};

const CHANNEL_BADGES_JSON: BadgesResponse = {
  badge_sets: {
    subscriber: {
      versions: {
        '0': {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/a8cfb12a-a0c2-4cc2-a5bd-a29184c0e6d8/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/a8cfb12a-a0c2-4cc2-a5bd-a29184c0e6d8/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/a8cfb12a-a0c2-4cc2-a5bd-a29184c0e6d8/3',
          description: 'Subscriber',
          title: 'Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
        '12': {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/9fbd7827-60f4-4cce-b8a9-ea9a163eeea5/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/9fbd7827-60f4-4cce-b8a9-ea9a163eeea5/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/9fbd7827-60f4-4cce-b8a9-ea9a163eeea5/3',
          description: '1-Year Subscriber',
          title: '1-Year Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
        '24': {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/85b53039-7dbf-4b27-9e4f-1ddff749f8b5/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/85b53039-7dbf-4b27-9e4f-1ddff749f8b5/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/85b53039-7dbf-4b27-9e4f-1ddff749f8b5/3',
          description: '2-Year Subscriber',
          title: '2-Year Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
        '3': {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/4edcfa74-2775-41f4-aedb-4b58ebdb3095/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/4edcfa74-2775-41f4-aedb-4b58ebdb3095/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/4edcfa74-2775-41f4-aedb-4b58ebdb3095/3',
          description: '3-Month Subscriber',
          title: '3-Month Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
        '6': {
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/3e64f2b2-47ad-46ab-b581-b9c7fd9055f3/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/3e64f2b2-47ad-46ab-b581-b9c7fd9055f3/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/3e64f2b2-47ad-46ab-b581-b9c7fd9055f3/3',
          description: '6-Month Subscriber',
          title: '6-Month Subscriber',
          click_action: 'subscribe_to_channel',
          click_url: '',
        },
      },
    },
  },
};

function mockGlobalBadges(): void {
  fetchMock.mock(GLOBAL_BADGES_URL, { body: GLOBAL_BADGES_JSON });
}

function mockChannelBadges(): void {
  fetchMock.mock(makeChannelBadgeURL(TEST_CHANNEL_ID), {
    body: CHANNEL_BADGES_JSON,
  });
}

export function mockChannel2Badges(): void {
  fetchMock.mock(makeChannelBadgeURL(TEST_CHANNEL_ID_2), {
    body: CHANNEL_BADGES_JSON,
  });
}

export function mockAllBadges(): void {
  mockGlobalBadges();
  mockChannelBadges();
}
