import {
  ChatClient,
  ConnectedHandler,
  DisconnectedHandler,
  HostingHandler,
  UnhostHandler,
  ReconnectHandler,
  ChatHandler,
  ModerationHandler,
  SubscriptionHandler,
  ResubscriptionHandler,
} from 'mweb/chat/chatClient';

export default class ChatClientMock implements ChatClient {
  client: any;
  currentChannel: string;
  connected: boolean;
  connectedHandler: ConnectedHandler;
  disconnectedHandler: DisconnectedHandler;
  reconnectHandler: ReconnectHandler;
  hostingHandler: HostingHandler;
  unhostHandler: UnhostHandler;
  chatHandler: ChatHandler;
  actionHandler: ChatHandler;
  timeoutHandler: ModerationHandler;
  banHandler: ModerationHandler;
  subscriptionHandler: SubscriptionHandler;
  resubscriptionHandler: ResubscriptionHandler;

  constructor() {
    this.connected = false;
  }

  connect(channel: string): Promise<void> {
    this.connected = true;
    this.currentChannel = channel;
    return Promise.resolve(undefined);
  }

  disconnect(): Promise<void> {
    this.connected = false;
    return Promise.resolve(undefined);
  }

  changeChannel(channel: string): Promise<void> {
    this.currentChannel = channel;
    return Promise.resolve(undefined);
  }

  setConnectedHandler(connectedHandler: ConnectedHandler): void {
    this.connectedHandler = connectedHandler;
  }

  setDisconnectedHandler(disconnectedHandler: DisconnectedHandler): void {
    this.disconnectedHandler = disconnectedHandler;
  }

  setReconnectHandler(reconnectHandler: ReconnectHandler): void {
    this.reconnectHandler = reconnectHandler;
  }

  setHostingHandler(hostingHandler: HostingHandler): void {
    this.hostingHandler = hostingHandler;
  }

  setUnhostHandler(unhostHandler: UnhostHandler): void {
    this.unhostHandler = unhostHandler;
  }

  setChatHandler(chatHandler: ChatHandler): void {
    this.chatHandler = chatHandler;
    return;
  }

  setActionHandler(actionHandler: ChatHandler): void {
    this.actionHandler = actionHandler;
    return;
  }

  setTimeoutHandler(timeoutHandler: ModerationHandler): void {
    this.timeoutHandler = timeoutHandler;
    return;
  }

  setBanHandler(banHandler: ModerationHandler): void {
    this.banHandler = banHandler;
    return;
  }

  setSubcriptionHandler(subscriptionHandler: SubscriptionHandler): void {
    this.subscriptionHandler = subscriptionHandler;
    return;
  }

  setResubscriptionHandler(resubscriptionHandler: ResubscriptionHandler): void {
    this.resubscriptionHandler = resubscriptionHandler;
    return;
  }

  isSocketOpen(): boolean {
    return true;
  }
}
