import expect from 'expect';

import { ClientRedirectManager } from 'mweb/client/clientRedirectManager';
import { MobileWebCookie } from 'mweb/common/utils/cookie';

describe('ClientRedirectManager', () => {
  function subject(
    path: string,
    cookie?: MobileWebCookie,
  ): ClientRedirectManager {
    const defaultCookie = { upsell_opt_out: false };
    return new ClientRedirectManager(
      path.split('/'),
      {
        ...defaultCookie,
        ...cookie,
      },
      'iPad',
    );
  }
  describe('redirectToMobileWeb', () => {
    const TEST_CASES = [
      { redirect: false, path: 'p/legal' },
      { redirect: true, path: 'monstercat' },
      { redirect: true, path: 'directory' },
      { redirect: true, path: 'monstercat/profile' },
      { redirect: true, path: 'directory/game/Afterlife' },
    ];

    TEST_CASES.forEach(({ redirect, path }) => {
      it(`${redirect ? 'redirects' : 'rejects'} ${path}`, () => {
        expect(subject(path).redirectToMobileWeb()).toEqual(redirect);
      });
    });
  });
});
