import * as React from 'react';
import expect from 'expect';
import { asListItem } from 'mweb/common/components/asListItem';
import faker from 'faker';
import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';

interface TestProps {
  whatever: string;
  interactionContent: string;
}

describe('asListItem', () => {
  const TestElement = (_: TestProps): JSX.Element => <div />;
  const TestListElement = asListItem(TestElement);
  const DEFAULT_PROPS = {
    position: faker.random.number(),
    whatever: faker.hacker.noun(),
  };
  const subject = partialPropShallowWrapper(TestListElement, DEFAULT_PROPS);

  it('sets interactionContent based on asListItem position and forwards props except position', () => {
    expect(
      subject()
        .first()
        .props(),
    ).toEqual({
      interactionContent: `position_${DEFAULT_PROPS.position}`,
      whatever: DEFAULT_PROPS.whatever,
      children: undefined,
    });
  });
});
