import expect from 'expect';
import times from 'lodash-es/times';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';

import {
  ChannelListBase as ChannelList,
  ChannelListProps,
} from 'mweb/common/components/channelList';
import {
  ChannelSubscribableStatus,
  ChannelOnlineStatus,
} from 'mweb/common/reducers/data/channels';

describe('<ChannelList />', () => {
  const DEFAULT_PROPS: ChannelListProps = {
    channels: [
      {
        name: 'voxel',
        displayName: 'Voxel',
        game: 'Afterlife',
        logoURL: '',
        id: '12',
        onlineStatus: ChannelOnlineStatus.Unknown,
        preview: 'https://{width}/{height}',
        status: 'Watch me play this awesome game from the 90s!',
        viewerCount: 9001,
        hostedChannel: '',
        subscribableStatus: ChannelSubscribableStatus.CanSubscribe,
        followerCount: 0,
        lifetimeViewerCount: 0,
        description: 'hello BigAndy',
        bannerImageURL: 'https://alec-lee.com',
      },
    ],
    getNextPage: () => [],
    gameDisplayName: 'Frank',
  };

  const subject = partialPropShallowWrapper(ChannelList, DEFAULT_PROPS);

  it('renders a List object', () => {
    expect(subject().find('List').length).toEqual(1);
  });

  describe('the list', () => {
    it('uses the actual length when above the floor', () => {
      const channels = times(510, () => DEFAULT_PROPS.channels[0]);
      expect(
        subject({ channels })
          .find('List')
          .prop('length'),
      ).toEqual(510);
    });

    it('passes through the next page function', () => {
      expect(
        subject()
          .find('List')
          .prop('getNextPage'),
      ).toEqual(DEFAULT_PROPS.getNextPage);
    });
  });
});
