import { shallow, ShallowWrapper } from 'enzyme';
import expect from 'expect';
import * as React from 'react';
import { ChannelOfflineToast } from 'src/common/components/channelOfflineToast';

import { OFFLINE_NOTIFICATION_TIME_IN_SECONDS } from 'mweb/common/components/channelOfflineToast';
import { ChannelOnlineStatus } from 'mweb/common/reducers/data/channels';
import { CHANNEL_DETAILS } from 'mtest/fetchMocks/channel';

describe('<ChannelOfflineToast/>', () => {
  function subject(offline: boolean = true): ShallowWrapper<{}, {}> {
    const details = { ...CHANNEL_DETAILS };
    if (offline) {
      details.onlineStatus = ChannelOnlineStatus.Offline;
    }
    return shallow(<ChannelOfflineToast {...details} />);
  }
  describe('rendering', () => {
    it('renders the timed toast', () => {
      expect(subject().find('TimedToast')).toHaveProp(
        'secondsVisible',
        OFFLINE_NOTIFICATION_TIME_IN_SECONDS,
      );
    });

    it('renders the formattedmessage', () => {
      const formattedMessage = subject().find('FormattedMessage');
      expect(formattedMessage).toHaveProps({
        values: { channel: CHANNEL_DETAILS.displayName },
        id: 'channel-offline-toast-message',
      });
    });
  });
});
