import expect from 'expect';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import {
  mockLatencyReporter,
  mockReportLatencyEvent,
} from 'mtest/helpers/customLatency';

import {
  ChannelViewerBottomPaneBase as ChannelViewerBottomPane,
  ChannelViewerBottomPaneProps,
} from 'mweb/common/components/channelViewerBottomPane';
import Spinner from 'mweb/common/components/spinner';
import ChatPane from 'mweb/chat/components/chatPane';
import { SwitchToDesktop } from 'mweb/common/components/switchToDesktop';
import { DiscoverMore } from 'mweb/common/components/discoverMore';

describe('<ChannelViewBottomPane/>', () => {
  const DEFAULT_PROPS: ChannelViewerBottomPaneProps = {
    showChat: undefined,
    isChatReady: false,
    game: 'Creative',
    switchToDesktop: () => undefined,
    chatMessages: [],
    reportLatencyEvent: mockReportLatencyEvent,
  };

  const subject = partialPropShallowWrapper(
    ChannelViewerBottomPane,
    DEFAULT_PROPS,
  );

  beforeEach(() => {
    mockLatencyReporter.reset();
  });

  after(() => {
    mockLatencyReporter.reset();
  });

  it('shows discover/switch when showChat is false', () => {
    const channel = subject({ showChat: false });
    expect(channel).toContain(DiscoverMore);
    expect(channel).toContain(SwitchToDesktop);
    expect(channel).toNotContain(ChatPane);
    expect(channel).toNotContain(Spinner);

    expect(mockLatencyReporter.chatConnected.called).toBeFalsy();
  });

  it('shows chat when chat is ready and showChat is true', () => {
    const channel = subject({ isChatReady: true, showChat: true });
    expect(channel).toNotContain(DiscoverMore);
    expect(channel).toNotContain(SwitchToDesktop);
    expect(channel).toContain(ChatPane);
    expect(channel).toNotContain(Spinner);

    expect(mockLatencyReporter.chatConnected.called).toBeTruthy();
  });

  it('shows a spinner when showChat is undefined and chat is not ready', () => {
    const channel = subject();
    expect(channel).toNotContain(DiscoverMore);
    expect(channel).toNotContain(SwitchToDesktop);
    expect(channel).toNotContain(ChatPane);
    expect(channel).toContain(Spinner);

    expect(mockLatencyReporter.chatConnected.called).toBeFalsy();
  });

  it('shows a spinner when showChat is undefined and chat is ready', () => {
    const channel = subject({ isChatReady: true });
    expect(channel).toNotContain(DiscoverMore);
    expect(channel).toNotContain(SwitchToDesktop);
    expect(channel).toNotContain(ChatPane);
    expect(channel).toContain(Spinner);

    expect(mockLatencyReporter.chatConnected.called).toBeFalsy();
  });

  it('shows a spinner when showChat is true and chat is not ready', () => {
    const channel = subject({ showChat: true });
    expect(channel).toNotContain(DiscoverMore);
    expect(channel).toNotContain(SwitchToDesktop);
    expect(channel).toNotContain(ChatPane);
    expect(channel).toContain(Spinner);

    expect(mockLatencyReporter.chatConnected.called).toBeFalsy();
  });
});
