import * as React from 'react';
import { shallow, ShallowWrapper } from 'enzyme';
import expect from 'expect';

import { DeclineUpsell } from 'mweb/common/components/declineUpsell';

describe('<DeclineUpsell />', () => {
  function subject(
    handler: React.EventHandler<any> = () => {
      return;
    },
  ): ShallowWrapper<{}, {}> {
    return shallow(<DeclineUpsell onClick={handler} />);
  }

  it('has the proper class', () => {
    expect(subject().contains(<p className="decline_upsell" />));
  });

  it('has the proper text', () => {
    expect(
      subject()
        .find('FormattedMessage')
        .prop('id'),
    ).toEqual('decline-upsell--message');
  });

  it('handles clicks', () => {
    let wasClicked = false;
    subject(() => (wasClicked = true)).simulate('click');
    expect(wasClicked).toEqual(true);
  });
});
