import expect from 'expect';
import faker from 'faker';
import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import {
  EventBanner,
  EventBannerProps,
  COVER_IMAGE_WIDTH,
  COVER_IMAGE_HEIGHT,
} from 'mweb/common/components/eventBanner';
import { EventCalendar } from 'mweb/common/components/eventCalendar';

describe('<EventBanner />', () => {
  const coverImageTemplateURL = 'https://alec-lee.com/bus-{width}x{height}';
  const DEFAULT_PROPS: EventBannerProps = {
    startTime: faker.date.past(),
    coverImageTemplateURL,
  };

  const subject = partialPropShallowWrapper(EventBanner, DEFAULT_PROPS);
  it('passes start time down to calendar', () => {
    expect(
      subject()
        .find(EventCalendar)
        .prop('date'),
    ).toEqual(DEFAULT_PROPS.startTime);
  });

  it('creates banner image based off template', () => {
    const image = subject().find('.event-cover-image');
    expect(image.prop('src')).toEqual(
      `https://alec-lee.com/bus-${COVER_IMAGE_WIDTH}x${COVER_IMAGE_HEIGHT}`,
    );
  });
});
