import expect from 'expect';
import faker from 'faker';
import { FormattedDate } from 'react-intl';
import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import { EventCalendar } from 'mweb/common/components/eventCalendar';

describe('<EventCalendar />', () => {
  const date = faker.date.past();
  const subject = partialPropShallowWrapper(EventCalendar, {
    date,
  });

  it('passes start time down to calendar month', () => {
    expect(
      subject()
        .find('.event-calendar__month')
        .find(FormattedDate)
        .prop('value'),
    ).toEqual(date);
  });

  it('passes start time down to calendar day', () => {
    expect(
      subject()
        .find('.event-calendar__day')
        .find(FormattedDate)
        .prop('value'),
    ).toEqual(date);
  });
});
