import expect from 'expect';
import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import { Text } from 'twitch-core-ui';
import { Timespan } from 'mweb/common/components/timespan';
import { EventInfo, EventInfoProps } from 'mweb/common/components/eventInfo';
import { PremiereStatus } from 'mweb/common/reducers/data/events';
import { EVENT_MODEL } from 'mtest/fetchMocks/event';

describe('<EventInfo />', () => {
  const DEFAULT_PROPS: EventInfoProps = {
    title: EVENT_MODEL.title,
    startTime: new Date(EVENT_MODEL.startTime),
    endTime: new Date(EVENT_MODEL.endTime),
    premiereStatus: undefined,
  };

  const subject = partialPropShallowWrapper(EventInfo, DEFAULT_PROPS);

  it('sets event title', () => {
    expect(
      subject()
        .find(Text)
        .shallow()
        .text(),
    ).toEqual(EVENT_MODEL.title);
  });

  it('sets event timespan props', () => {
    const timespan = subject().find(Timespan);
    expect(timespan.prop('start')).toEqual(new Date(EVENT_MODEL.startTime));
    expect(timespan.prop('end')).toEqual(new Date(EVENT_MODEL.endTime));
  });

  describe('premiere specific views', () => {
    it('does not add event type if no PremiereStatus provided', () => {
      expect(subject().find('.premiere-title').length).toEqual(0);
    });

    it('does add event type if PremiereStatus provided', () => {
      expect(
        subject({ premiereStatus: PremiereStatus.Started }).find(
          '.premiere-title',
        ).length,
      ).toEqual(1);
    });
  });
});
