import * as React from 'react';
import { shallow, ShallowWrapper } from 'enzyme';
import expect from 'expect';
import times from 'lodash-es/times';

import { makeFakeGame } from 'mtest/fetchMocks/games';

import { GameList } from 'mweb/common/components/gameList';

describe('<GameList />', () => {
  function getNextPage(): any[] {
    return [];
  }

  const GAMES = [makeFakeGame()];

  function subject(): ShallowWrapper<{}, {}> {
    return shallow(<GameList games={GAMES} getNextPage={getNextPage} />);
  }

  it('renders a List object', () => {
    expect(subject().find('List').length).toEqual(1);
  });

  describe('the list', () => {
    function list(): ShallowWrapper<{}, {}> {
      return subject().find('List');
    }

    it('uses the actual length when above the floor', () => {
      expect(
        shallow(
          <GameList
            games={times(510, () => GAMES[0])}
            getNextPage={getNextPage}
          />,
        )
          .find('List')
          .prop('length'),
      ).toEqual(510);
    });

    it('passes through the next page function', () => {
      expect(list().prop('getNextPage')).toEqual(getNextPage);
    });
  });
});
