import expect from 'expect';
import { CardImage } from 'twitch-core-ui';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import {
  CardImageWrapper,
  LatencyTrackedCardImage,
} from 'mweb/common/components/more-ui/cardImageWrapper';

describe('<CardImageWrapper/>', () => {
  const subject = partialPropShallowWrapper(CardImageWrapper, {});
  it('renders a latency tracked card image', () => {
    expect(
      subject({ latencyTracked: true }).find(LatencyTrackedCardImage),
    ).toExist();
  });

  it('renders a non latency tracked card image without a refHandler', () => {
    expect(subject({ latencyTracked: false }).find(CardImage)).toNotHaveProp(
      'refHandler',
    );
  });
});
