import expect from 'expect';
import { Button } from 'twitch-core-ui';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import { trackClickMock, testClickTracking } from 'mtest/helpers/tracking';
import { TrackClickHandler } from 'mweb/common/tracking/withTracking';

import {
  ProfileEmptyStateBase as ProfileEmptyState,
  ProfileEmptyStateProps,
  INTERACTION_CONTENT_BROWSE_TWITCH,
} from 'mweb/common/components/profileEmptyState';
import { buildGameDirectoryPath } from 'mweb/common/utils/pathBuilders';

const DEFAULT_PROPS: ProfileEmptyStateProps = {
  trackClick: trackClickMock(),
};

describe('<ProfileEmptyState />', () => {
  const subject = partialPropShallowWrapper(ProfileEmptyState, DEFAULT_PROPS);

  it('renders browse twitch button with proper link', () => {
    expect(subject().find(Button)).toHaveProp(
      'linkTo',
      buildGameDirectoryPath(),
    );
  });

  testClickTracking({
    title: 'tracks clicks on browse twitch button',
    expectedPayload: {
      interactionContent: INTERACTION_CONTENT_BROWSE_TWITCH,
    },
    clickTargetBuilder: (trackClick: TrackClickHandler) =>
      subject({ trackClick }).find(Button),
  });
});
