import expect from 'expect';
import { FormattedMessage } from 'react-intl';
import { Button, ButtonType } from 'twitch-core-ui';

import { trackClickMock, testClickTracking } from 'mtest/helpers/tracking';
import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';

import {
  ShareButtonBase as ShareButton,
  ShareButtonProps,
  INTERACTION_CONTENT_SHARE,
} from 'mweb/common/components/shareButton';
import { Location } from 'mweb/common/reducers/app';
import { TrackClickHandler } from 'mweb/common/tracking/withTracking';

describe('<ShareButton />', () => {
  const DEFAULT_PROPS: ShareButtonProps = {
    shareSheetHeader: 'Fun Header',
    title: 'A Titular Title',
    appLocation: Location.EventDetails,
    handleShare: () => {
      return;
    },
    trackClick: trackClickMock(),
  };

  const subject = partialPropShallowWrapper(ShareButton, DEFAULT_PROPS);

  it('renders the right button text', () => {
    expect(
      subject()
        .find(FormattedMessage)
        .prop('id'),
    ).toEqual('share-button--top-level-message');
  });

  it('has the correct button type', () => {
    const button = subject().find(Button);
    expect(button).toHaveProp('type', ButtonType.Hollow);
  });

  it('toggles state sharingDockOpen when the button is clicked', () => {
    const share = subject();
    expect(share).toHaveState({ sharingDockOpen: false });

    share.find(Button).simulate('click');
    expect(share).toHaveState({ sharingDockOpen: true });

    share.find(Button).simulate('click');
    expect(share).toHaveState({ sharingDockOpen: false });
  });

  testClickTracking([
    {
      title: 'tracks clicks on share',
      expectedPayload: {
        interactionContent: INTERACTION_CONTENT_SHARE,
      },
      clickTargetBuilder: (trackClick: TrackClickHandler) =>
        subject({ trackClick }).find(Button),
    },
  ]);
});
