import expect from 'expect';
import { Text } from 'twitch-core-ui';
const Clipboard = require('react-clipboard.js').default;

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import { trackClickMock, testClickTracking } from 'mtest/helpers/tracking';

import { TrackClickHandler } from 'mweb/common/tracking/withTracking';
import {
  ShareSheetItemBase as ShareSheetItem,
  ShareSheetItemProps,
} from 'mweb/common/components/shareSheetItem';

describe('<ShareSheetItem />', () => {
  const DEFAULT_PROPS: ShareSheetItemProps = {
    displayName: 'BigAndy',
    interactionContent: 'fun content',
    url: 'www.alec-lee.com',
    handleShare: () => undefined,
    trackClick: trackClickMock(),
  };

  const subject = partialPropShallowWrapper(ShareSheetItem, DEFAULT_PROPS);

  it('renders share item', () => {
    const item = subject();
    expect(
      item
        .find(Text)
        .shallow()
        .text(),
    ).toEqual(DEFAULT_PROPS.displayName);
    expect(item.find('a').prop('href')).toEqual(DEFAULT_PROPS.url);
  });

  it('renders clipboard item', () => {
    const item = subject({ isClipboard: true }).find(Clipboard);
    expect(
      item
        .find(Text)
        .shallow()
        .text(),
    ).toEqual(DEFAULT_PROPS.displayName);
  });

  testClickTracking([
    {
      title: 'tracks clicks for share items',
      expectedPayload: {
        interactionContent: DEFAULT_PROPS.interactionContent,
      },
      clickTargetBuilder: (trackClick: TrackClickHandler) => {
        const share = subject({ trackClick });
        return share.find('a');
      },
    },
  ]);
});
