import expect from 'expect';
import { spy } from 'sinon';
import { FormattedMessage } from 'react-intl';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';
import { testClickTracking, trackClickMock } from 'mtest/helpers/tracking';

import {
  SwitchToDesktopBase as SwitchToDesktop,
  SwitchToDesktopProps,
  INTERACTION_CONTENT_SWITCH_TO_DESKTOP,
} from 'mweb/common/components/switchToDesktop';
import { TrackClickHandler } from 'mweb/common/tracking/withTracking';

describe('<SwitchToDesktop />', () => {
  const switchToDesktop = spy();

  const DEFAULT_PROPS: SwitchToDesktopProps = {
    switchToDesktop,
    trackClick: trackClickMock(),
  };

  const subject = partialPropShallowWrapper(SwitchToDesktop, DEFAULT_PROPS);

  it('formats a message with the right ID', () => {
    expect(
      subject()
        .find(FormattedMessage)
        .prop('id'),
    ).toEqual('switch-to-desktop--message');
  });

  it('triggers switch to desktop function on click', () => {
    const target = subject().find('a');

    expect(switchToDesktop.called).toEqual(false);
    target.simulate('click');
    expect(switchToDesktop.called).toEqual(true);
  });

  testClickTracking([
    {
      title: 'tracks clicks',
      expectedPayload: {
        interactionContent: INTERACTION_CONTENT_SWITCH_TO_DESKTOP,
      },
      clickTargetBuilder: (trackClick: TrackClickHandler) =>
        subject({ trackClick }).find('a'),
    },
  ]);
});
