import * as React from 'react';
import { shallow, ShallowWrapper } from 'enzyme';
import expect from 'expect';
import { FormattedDate, FormattedTime } from 'react-intl';

import { Timespan } from 'mweb/common/components/timespan';

describe('<Timespan />', () => {
  function subject(start: Date, end: Date): ShallowWrapper<{}, {}> {
    return shallow(<Timespan start={start} end={end} />);
  }

  describe('on the same day', () => {
    const startDate = new Date(100);
    const endDate = new Date(200);

    it('has has the start date', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedDate)
          .first()
          .prop('value'),
      ).toEqual(startDate);
    });

    it('has the start time', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedTime)
          .first()
          .prop('value'),
      ).toEqual(startDate);
    });

    it('has the end time', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedTime)
          .last()
          .prop('value'),
      ).toEqual(endDate);
    });
  });

  describe('on different days', () => {
    const startDate = new Date(100);
    const endDate = new Date(200000000);

    it('has has the start date', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedDate)
          .first()
          .prop('value'),
      ).toEqual(startDate);
    });

    it('has has the end date', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedDate)
          .last()
          .prop('value'),
      ).toEqual(endDate);
    });

    it('has the start time', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedTime)
          .first()
          .prop('value'),
      ).toEqual(startDate);
    });

    it('has the end time', () => {
      expect(
        subject(startDate, endDate)
          .find(FormattedTime)
          .last()
          .prop('value'),
      ).toEqual(endDate);
    });
  });
});
