require('jsdom-global')();

import expect from 'expect';

import { partialPropMountWrapper } from 'mtest/helpers/partialPropWrappers';
import TwitchPlayerMock, {
  ITwitchPlayerMock,
} from 'mtest/helpers/twitchPlayerMock';
import {
  mockLatencyReporter,
  mockReportLatencyEvent,
} from 'mtest/helpers/customLatency';

import {
  ChannelVideoPlayerBase as ChannelVideoPlayer,
  ChannelVideoPlayerProps,
} from 'mweb/common/components/videoPlayer/channel';

describe('<ChannelVideoPlayer />', () => {
  before(() => {
    window.Twitch = {
      Player: TwitchPlayerMock,
    };
  });

  after(() => {
    delete window.Twitch;
    mockLatencyReporter.reset();
  });

  const DEFAULT_PROPS: ChannelVideoPlayerProps = {
    channel: 'voxel',
    sessionID: 'alecleewuzhere',
    reportLatencyEvent: mockReportLatencyEvent,
  };

  const subject = partialPropMountWrapper(ChannelVideoPlayer, DEFAULT_PROPS);

  it('handles changing the channel', () => {
    const wrapper = subject();
    const videoPlayer = wrapper.instance() as ChannelVideoPlayer;
    const player = videoPlayer.player as ITwitchPlayerMock;
    expect(player.channelName).toEqual('voxel');

    wrapper.setProps({ channel: 'monstercat' });
    expect(player.channelName).toEqual('monstercat');
  });
});
