require('jsdom-global')();

import expect from 'expect';

import { partialPropMountWrapper } from 'mtest/helpers/partialPropWrappers';
import TwitchPlayerMock, {
  ITwitchPlayerMock,
} from 'mtest/helpers/twitchPlayerMock';
import {
  mockLatencyReporter,
  mockReportLatencyEvent,
} from 'mtest/helpers/customLatency';

import {
  VODVideoPlayerBase as VODVideoPlayer,
  VODVideoPlayerProps,
} from 'mweb/common/components/videoPlayer/vod';

describe('<VODVideoPlayer />', () => {
  before(() => {
    window.Twitch = {
      Player: TwitchPlayerMock,
    };
  });

  after(() => {
    delete window.Twitch;
    mockLatencyReporter.reset();
  });

  const DEFAULT_PROPS: VODVideoPlayerProps = {
    vodID: '12345',
    vodInitialOffset: undefined,
    sessionID: 'alecleewuzhere2',
    reportLatencyEvent: mockReportLatencyEvent,
  };

  const subject = partialPropMountWrapper(VODVideoPlayer, DEFAULT_PROPS);

  it('initializes the player properly without offset', () => {
    const playerWrapper = subject();
    const videoPlayer = playerWrapper.instance() as VODVideoPlayer;
    const player = videoPlayer.player as ITwitchPlayerMock;
    expect(player.videoID).toEqual('v12345');
    expect(player.seekTimestamp).toNotExist();
  });

  it('seeks when given an initialOffset', () => {
    const videoPlayer = subject({
      vodInitialOffset: '1m',
    }).instance() as VODVideoPlayer;
    const player = videoPlayer.player as ITwitchPlayerMock;
    expect(player.videoID).toEqual('v12345');
    expect(player.seekTimestamp).toEqual(60);
  });
});
