import * as React from 'react';
import expect from 'expect';
import { mount } from 'enzyme';
import { spy } from 'sinon';

import {
  ExperimentBase as Experiment,
  Treatment,
} from 'mweb/common/containers/experiment';
import {
  ExperimentGroups,
  ExperimentNames,
  ExperimentUUIDs,
} from 'mweb/common/actions/experiments';

describe('<Experiment/>', () => {
  beforeEach(() => {
    recordExperimentDecision.reset();
  });

  const recordExperimentDecision = spy(() => undefined);

  it('renders treatment group if active group is Treatment and records decision', () => {
    const experimentData = {
      uuid: ExperimentUUIDs.Test,
      name: ExperimentNames.Test,
      group: ExperimentGroups.Treatment,
    };
    const experiment = mount(
      <Experiment
        experimentData={experimentData}
        experimentName={ExperimentNames.Test}
        recordExperimentDecision={recordExperimentDecision}
      >
        <Treatment group={ExperimentGroups.Treatment}>
          <div className="andy" />
        </Treatment>
        <Treatment group={ExperimentGroups.Control}>
          <div className="big" />
        </Treatment>
      </Experiment>,
    );
    expect(experiment).toContain('.andy');
    expect(experiment).toNotContain('.big');
    expect(recordExperimentDecision.calledOnce).toBeTruthy();
  });

  it('renders control group if active group is Control and records decision', () => {
    const experimentData = {
      uuid: ExperimentUUIDs.Test,
      name: ExperimentNames.Test,
      group: ExperimentGroups.Control,
    };
    const experiment = mount(
      <Experiment
        experimentData={experimentData}
        experimentName={ExperimentNames.Test}
        recordExperimentDecision={recordExperimentDecision}
      >
        <Treatment group={ExperimentGroups.Treatment}>
          <div className="andy" />
        </Treatment>
        <Treatment group={ExperimentGroups.Control}>
          <div className="big" />
        </Treatment>
      </Experiment>,
    );
    expect(experiment).toNotContain('.andy');
    expect(experiment).toContain('.big');
    expect(recordExperimentDecision.calledOnce).toBeTruthy();
  });

  it('does not record decision if preventRecordingDecision is true', () => {
    const experimentData = {
      uuid: ExperimentUUIDs.Test,
      name: ExperimentNames.Test,
      group: ExperimentGroups.Control,
    };
    mount(
      <Experiment
        experimentData={experimentData}
        experimentName={ExperimentNames.Test}
        recordExperimentDecision={recordExperimentDecision}
        preventRecordingDecision={true}
      />,
    );
    expect(recordExperimentDecision.calledOnce).toBeFalsy();
  });
});
