import expect from 'expect';
import Helmet from 'react-helmet';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';

import {
  ANDROID_PACKAGE_NAME,
  APPLE_APP_ID,
  FAVICON_LOCATION,
  FAVICON_TYPE,
  Head,
  HeaderProps,
  VIEWPORT_VALUE,
} from 'mweb/common/containers/head';

describe('<Head/>', () => {
  const DEFAULT_PROPS: HeaderProps = {
    referrer: document.referrer,
    path: '/directory',
  };

  const subject = partialPropShallowWrapper(Head, DEFAULT_PROPS);

  it('renders the default title', () => {
    expect(
      subject()
        .find(Helmet)
        .prop('defaultTitle'),
    ).toEqual('Twitch');
  });

  it('sets the viewport value', () => {
    expect(
      subject()
        .find('meta[name="viewport"]')
        .prop('content'),
    ).toEqual(VIEWPORT_VALUE);
  });

  it('sets the favicon location', () => {
    expect(
      subject()
        .find('link[rel="shortcut icon"]')
        .prop('href'),
    ).toEqual(FAVICON_LOCATION);
  });

  it('sets the favicon type', () => {
    expect(
      subject()
        .find('link[rel="shortcut icon"]')
        .prop('type'),
    ).toEqual(FAVICON_TYPE);
  });

  describe('for app links', () => {
    it('builds the iOS deep link', () => {
      expect(
        subject({ referrer: 'ref' })
          .find('meta[property="al:ios:url"]')
          .prop('content'),
      ).toEqual('twitch://m.twitch.tv/directory?referrer=ref');
    });

    it('builds the App Store ID', () => {
      expect(
        subject()
          .find('meta[property="al:ios:app_store_id"]')
          .prop('content'),
      ).toEqual(APPLE_APP_ID);
    });

    it('builds the iOS app name', () => {
      expect(
        subject()
          .find('meta[property="al:ios:app_name"]')
          .prop('content'),
      ).toEqual('Twitch');
    });

    it('builds the Android deep link', () => {
      expect(
        subject({ referrer: 'fer' })
          .find('meta[property="al:android:url"]')
          .prop('content'),
      ).toEqual('twitch://m.twitch.tv/directory?referrer=fer');
    });

    it('builds the Android Package', () => {
      expect(
        subject()
          .find('meta[property="al:android:package"]')
          .prop('content'),
      ).toEqual(ANDROID_PACKAGE_NAME);
    });

    it('builds the Twitch app name', () => {
      expect(
        subject()
          .find('meta[property="al:android:app_name"]')
          .prop('content'),
      ).toEqual('Twitch');
    });
  });
});
