import expect from 'expect';
import { match } from 'react-router-dom';
import { Location, History } from 'history';

import { partialPropShallowWrapper } from 'mtest/helpers/partialPropWrappers';

import { VODVideoPlayer } from 'mweb/common/components/videoPlayer/vod';
import InfoBox from 'mweb/common/components/infoBox';
import {
  VODViewer,
  VODViewerProps,
  VODViewerMatchParams,
} from 'mweb/common/containers/vodViewer';
import { SwitchToDesktop } from 'mweb/common/components/switchToDesktop';
import { DiscoverMore } from 'mweb/common/components/discoverMore';
import { BranchUpsellExperiment } from 'mweb/common/components/branchUpsell';
import { BranchJourneyType } from 'branch-io';

describe('<VODViewer/>', () => {
  const DEFAULT_PROPS: VODViewerProps = {
    channelName: 'voxel',
    channelDisplayName: 'Voxel',
    logoUrl: 'http://voxel.logo',
    game: 'creative',
    vodTitle: 'Voxel Goes Fishing',
    sessionID: 'sessionID',
    transitionToTargetVOD: () => undefined,
    switchToDesktop: () => undefined,
    match: {
      params: {
        vodID: '12345',
      },
    } as match<VODViewerMatchParams>,
    location: { pathname: '/videos/12345', search: '' } as Location,
    history: {} as History,
  };

  const subject = partialPropShallowWrapper(VODViewer, DEFAULT_PROPS);

  it('shows the video player and info box for a vod', () => {
    const vod = subject();
    expect(vod).toContain(VODVideoPlayer);
    expect(vod).toContain(InfoBox);
    expect(vod).toContain(DiscoverMore);
    expect(vod).toContain(SwitchToDesktop);
  });

  it('creates branch upsell', () => {
    const vod = subject();
    expect(vod).toContain(BranchUpsellExperiment);
    expect(vod.find(BranchUpsellExperiment)).toHaveProps({
      delaySecondsUntilUpsell: 120,
      journey: {
        type: BranchJourneyType.Vod,
        channel: DEFAULT_PROPS.channelDisplayName,
      },
    });
  });
});
