import expect from 'expect';

import {
  GAMES_GQL,
  GAME_3,
  GAME_2,
  GAMES_GQL_LAST_CURSOR,
  GAMES_PAGE_3_GQL,
} from 'mtest/fetchMocks/games';

import { parseGamesGQL } from 'mweb/common/fetch/games';

describe('parseGamesGQL', () => {
  it('builds the correct payload from the JSON', () => {
    expect(parseGamesGQL(GAMES_GQL)).toEqual({
      gameDetails: {
        [GAME_3.name]: GAME_3,
        [GAME_2.name]: GAME_2,
      },
      lastGameCursor: GAMES_GQL_LAST_CURSOR,
    });
  });

  it('handles response with no games (end of list)', () => {
    expect(parseGamesGQL(GAMES_PAGE_3_GQL)).toEqual({
      gameDetails: {},
      lastGameCursor: null,
    });
  });
});
