import expect from 'expect';
import fetchMock from 'fetch-mock';

import {
  VOD,
  mockVOD,
  mockVODNotFound,
  VOD_DATA_PAYLOAD,
} from 'mtest/fetchMocks/vods';

import { fetchVOD, compileFetchVODOperation } from 'mweb/common/fetch/vods';

describe('fetchVOD', () => {
  afterEach(() => fetchMock.restore());

  describe('when a vod exists', () => {
    it('fetches a vod and returns the details', () => {
      mockVOD();
      return fetchVOD(VOD).then(result => {
        expect(
          JSON.parse((fetchMock.calls().matched[0][1] as any).body),
        ).toEqual({
          query: compileFetchVODOperation(),
          operationName: 'VideoQuery',
          variables: {
            vodID: VOD,
          },
        });
        expect(result).toEqual(VOD_DATA_PAYLOAD);
      });
    });
  });

  describe('when a vod does not exist', () => {
    it('returns null', () => {
      mockVODNotFound();
      return fetchVOD(VOD).then(result => {
        expect(result).toEqual(null);
      });
    });
  });
});
