import { makeFakeFetchChannelGQL } from 'mtest/fetchMocks/channel';
import { mockGQL, mockGQL404 } from 'mtest/fetchMocks/mockGQL';
import { GAME_1, GAME_2 } from 'mtest/fetchMocks/games';

import {
  ChannelsDataPayload,
  FetchChannelsGQL,
} from 'mweb/common/fetch/channels';
import {
  ALL_CHANNELS,
  ChannelOnlineStatus,
  ChannelDetailsMap,
  ChannelSubscribableStatus,
} from 'mweb/common/reducers/data/channels';

export const NOT_GAME_ALIAS = 'NotAGame';

export const GAME_JSON_CURSOR = 'b3BhcXVl';
export const GAME_JSON: FetchChannelsGQL = {
  data: {
    gameChannels: {
      ...GAME_1,
      streams: {
        pageInfo: {
          hasNextPage: true,
        },
        edges: [
          {
            cursor: GAME_JSON_CURSOR,
            node: {
              broadcaster: makeFakeFetchChannelGQL('awesome').data.user!,
            },
          },
        ],
      },
    },
  },
};

const broadcaster = GAME_JSON.data.gameChannels!.streams.edges[0].node
  .broadcaster;
export const GAME_CHANNEL_DETAILS_MAP: ChannelDetailsMap = {
  [broadcaster.login!]: {
    displayName: broadcaster.displayName!,
    game: broadcaster.stream!.game!.name,
    hostedChannel: undefined,
    id: broadcaster.id!,
    logoURL: broadcaster.profileImageURL!,
    name: broadcaster.login!,
    onlineStatus: ChannelOnlineStatus.Online,
    preview: broadcaster.stream!.previewImageURL!,
    status: broadcaster.stream!.title!,
    viewerCount: broadcaster.stream!.viewersCount!,
    bannerImageURL: broadcaster.bannerImageURL!,
    followerCount: broadcaster.followers!.totalCount,
    description: broadcaster.description!,
    lifetimeViewerCount: broadcaster.profileViewCount!,
    subscribableStatus: ChannelSubscribableStatus.CanSubscribe,
  },
};

export const GAME_CHANNELS_DATA_PAYLOAD: ChannelsDataPayload = {
  game: GAME_1,
  gameAliasUsed: GAME_1.name,
  cursor: GAME_JSON_CURSOR,
  channelDetails: GAME_CHANNEL_DETAILS_MAP,
};

export const GAME_JSON_PAGE_2: FetchChannelsGQL = {
  data: {
    gameChannels: {
      ...GAME_1,
      streams: {
        pageInfo: {
          hasNextPage: false,
        },
        edges: [],
      },
    },
  },
};

export const GAME_PAGE_2_CHANNEL_DETAILS_MAP: ChannelDetailsMap = {};

export const GAME_PAGE_2_CHANNELS_DATA_PAYLOAD: ChannelsDataPayload = {
  game: GAME_1,
  gameAliasUsed: GAME_1.name,
  cursor: null,
  channelDetails: GAME_PAGE_2_CHANNEL_DETAILS_MAP,
};

export const NO_STREAMS_JSON: FetchChannelsGQL = {
  data: {
    gameChannels: {
      ...GAME_2,
      streams: {
        pageInfo: {
          hasNextPage: false,
        },
        edges: [],
      },
    },
  },
};

export const NO_STREAMS_CHANNEL_DETAILS_MAP: ChannelDetailsMap = {};

export const NO_STREAMS_CHANNELS_DATA_PAYLOAD: ChannelsDataPayload = {
  game: GAME_2,
  gameAliasUsed: GAME_2.name,
  cursor: null,
  channelDetails: NO_STREAMS_CHANNEL_DETAILS_MAP,
};

export const NOT_GAME_JSON: FetchChannelsGQL = {
  data: {
    gameChannels: null,
  },
};

export const NOT_GAME_CHANNEL_DETAILS_MAP: ChannelDetailsMap = {};

export const NOT_GAME_CHANNELS_DATA_PAYLOAD: ChannelsDataPayload = {
  game: undefined,
  gameAliasUsed: NOT_GAME_ALIAS,
  cursor: null,
  channelDetails: NOT_GAME_CHANNEL_DETAILS_MAP,
};

export const ALL_GAMES_JSON: FetchChannelsGQL = {
  data: {
    allChannels: {
      pageInfo: {
        hasNextPage: false,
      },
      edges: [
        {
          cursor: 'abc',
          node: {
            broadcaster: makeFakeFetchChannelGQL('awesome', 0).data.user!,
          },
        },
        {
          cursor: 'def',
          node: {
            broadcaster: makeFakeFetchChannelGQL('otherAwesome', 0).data.user!,
          },
        },
      ],
    },
  },
};

const allGamesBroadcasters = ALL_GAMES_JSON.data.allChannels!.edges.map(
  edge => edge.node.broadcaster,
);
export const ALL_GAMES_CHANNEL_DETAILS_MAP: ChannelDetailsMap = {
  [allGamesBroadcasters[0].login!]: {
    displayName: allGamesBroadcasters[0].displayName!,
    game: allGamesBroadcasters[0].stream!.game!.name,
    hostedChannel: undefined,
    id: allGamesBroadcasters[0].id!,
    logoURL: allGamesBroadcasters[0].profileImageURL!,
    name: allGamesBroadcasters[0].login!,
    onlineStatus: ChannelOnlineStatus.Online,
    preview: allGamesBroadcasters[0].stream!.previewImageURL!,
    status: allGamesBroadcasters[0].stream!.title!,
    viewerCount: allGamesBroadcasters[0].stream!.viewersCount!,
    bannerImageURL: allGamesBroadcasters[0].bannerImageURL!,
    description: allGamesBroadcasters[0].description!,
    followerCount: allGamesBroadcasters[0].followers!.totalCount,
    lifetimeViewerCount: allGamesBroadcasters[0].profileViewCount!,
    subscribableStatus: ChannelSubscribableStatus.CanSubscribe,
  },
  [allGamesBroadcasters[1].login!]: {
    displayName: allGamesBroadcasters[1].displayName!,
    game: allGamesBroadcasters[1].stream!.game!.name,
    hostedChannel: undefined,
    id: allGamesBroadcasters[1].id!,
    logoURL: allGamesBroadcasters[1].profileImageURL!,
    name: allGamesBroadcasters[1].login!,
    onlineStatus: ChannelOnlineStatus.Online,
    preview: allGamesBroadcasters[1].stream!.previewImageURL!,
    status: allGamesBroadcasters[1].stream!.title!,
    viewerCount: allGamesBroadcasters[1].stream!.viewersCount!,
    bannerImageURL: allGamesBroadcasters[1].bannerImageURL!,
    description: allGamesBroadcasters[1].description!,
    followerCount: allGamesBroadcasters[1].followers!.totalCount,
    lifetimeViewerCount: allGamesBroadcasters[1].profileViewCount!,
    subscribableStatus: ChannelSubscribableStatus.CanSubscribe,
  },
};

export const ALL_GAMES_CHANNELS_DATA_PAYLOAD: ChannelsDataPayload = {
  game: undefined,
  gameAliasUsed: ALL_CHANNELS,
  cursor: null,
  channelDetails: ALL_GAMES_CHANNEL_DETAILS_MAP,
};

export function mockChannelsForGame(): void {
  mockGQL(GAME_JSON);
}

export function mockChannelsForGamePage2(): void {
  mockGQL(GAME_JSON_PAGE_2);
}

export function mockChannelsForGame404(): void {
  mockGQL404();
}

export function mockChannelsAllGames(): void {
  mockGQL(ALL_GAMES_JSON);
}

export function mockChannelsNoStreams(): void {
  mockGQL(NO_STREAMS_JSON);
}

export function mockChannelsNotGame(): void {
  mockGQL(NOT_GAME_JSON);
}
