import faker from 'faker';

import { formatVideoLength } from 'mweb/common/utils/formatVideoLength';
import { ClipDetails } from 'mweb/common/reducers/data/clips';
import { VideoType } from 'mweb/common/reducers/data/baseVideoDetails';

const length = faker.random.number();
export const CLIP_DETAILS: ClipDetails = {
  id: '123',
  title: faker.lorem.words(),
  thumbnailURL: faker.image.avatar(),
  url: 'http://alec-lee.com',
  date: faker.date.past().valueOf(),
  viewCount: faker.random.number(),
  game: faker.hacker.noun(),
  channel: faker.hacker.noun(),
  length,
  formattedLength: formatVideoLength(length),
  videoType: VideoType.Clip,
};
