import faker from 'faker';

import { mockGQL, mockGQL404 } from 'mtest/fetchMocks/mockGQL';

import { parseGamesGQL, GamesGQL } from 'mweb/common/fetch/games';
import { GameDetails } from 'mweb/common/reducers/data/games';

export function makeFakeGame(opts: Partial<GameDetails> = {}): GameDetails {
  const gameName = opts.name || faker.random.words(4);
  return {
    id: String(faker.random.number()),
    name: gameName,
    displayName: gameName.toUpperCase(),
    viewersCount: faker.random.number(),
    boxArtURL: faker.image.imageUrl(),
    ...opts,
  };
}

export const GAME_1 = makeFakeGame({ viewersCount: 1, name: 'game1' });
export const GAME_2 = makeFakeGame({ viewersCount: 2, name: 'game2' });
export const GAME_3 = makeFakeGame({ viewersCount: 3, name: 'game3' });

export const GAMES_GQL_LAST_CURSOR = 'G2';

export const GAMES_GQL: GamesGQL = {
  data: {
    games: {
      edges: [
        {
          cursor: 'G3',
          node: GAME_3,
        },
        {
          cursor: GAMES_GQL_LAST_CURSOR,
          node: GAME_2,
        },
      ],
    },
  },
};

export const PARSED_GAMES_PAYLOAD = parseGamesGQL(GAMES_GQL);

export const GAMES_PAGE_2_GQL_LAST_CURSOR = 'G1';

export const GAMES_PAGE_2_GQL: GamesGQL = {
  data: {
    games: {
      edges: [
        {
          cursor: GAMES_PAGE_2_GQL_LAST_CURSOR,
          node: GAME_1,
        },
      ],
    },
  },
};

export const PARSED_GAMES_PAGE_2_PAYLOAD = parseGamesGQL(GAMES_PAGE_2_GQL);

export const GAMES_PAGE_3_GQL: GamesGQL = {
  data: {
    games: {
      edges: [],
    },
  },
};

export function mockGames(): void {
  mockGQL(GAMES_GQL);
}

export function mockGamesPage2(): void {
  mockGQL(GAMES_PAGE_2_GQL);
}

export function mockGamesPage3(): void {
  mockGQL(GAMES_PAGE_3_GQL);
}

export function mockGames404(): void {
  mockGQL404();
}
